import * as React from 'react';

const DOUBLE_CLICK = 2;
const DOUBLE_CLICK_DELAY = 150;

export const useSingleDoubleClick = (actionClick, actionDoubleClick, delay = DOUBLE_CLICK_DELAY) => {
    const [click, setClick] = React.useState(0);
    const [event, setEvent] = React.useState<MouseEvent | undefined>(undefined);

    React.useEffect(() => {
        const timer = setTimeout(() => {
            if (click === 1) {
                actionClick?.(event);
            }
            setClick(0);
        }, delay);

        if (click === DOUBLE_CLICK) {
            actionDoubleClick?.(event);
        }

        return () => clearTimeout(timer);
    }, [click]);

    return (e: any) => {
        setClick((prev) => prev + 1);
        setEvent(e);
    };
};
