import { useContext, useEffect } from 'react';

import GlobalTooltipContext from 'contexts/GlobalTooltipContext';

export const useTooltipMouseHandler = (ref) => {
    const { setShow, setElementPosition, setElementSize, setTooltipOptions } = useContext(GlobalTooltipContext);

    useEffect(() => {
        let element = ref.current;
        const mouseEnterListener = () => {
            let viewportOffset = element?.getBoundingClientRect();
            let top = viewportOffset.top;
            let left = viewportOffset.left;
            let width = element?.offsetWidth;
            let height = element?.offsetHeight;

            setElementPosition([top, left]);
            setElementSize([width, height]);
        };

        const mouseLeaveListener = () => {
            setShow(false);
            setElementPosition([null, null]);
            setElementSize([null, null]);
            setTooltipOptions(null);
        };

        element?.addEventListener('mouseenter', () => {
            mouseEnterListener();
        });
        element?.addEventListener('mouseleave', () => {
            mouseLeaveListener();
        });

        return () => {
            setElementPosition([null, null]);
            setElementSize([null, null]);

            element?.removeEventListener('mouseenter', () => {
                mouseEnterListener();
            });
            element?.removeEventListener('mouseleave', () => {
                mouseLeaveListener();
            });
        };
    }, [ref]);
};
