import * as React from 'react';
import { MemoryRouter, Route } from 'react-router-dom';

import { withStorybookRouter } from 'tests/storybook/decorators/withStorybookRouter';
import { createStorybookMeta } from 'tests/storybook/helpers/createStorybookMeta';
import { createStorybookTemplate } from 'tests/storybook/helpers/createStorybookTemplate';
import { withRequestCacheLoader } from 'tests/storybook/loaders/withRequestCacheLoader';

import { CarDamagesPage } from 'pages/Car/Damages/ui/CarDamagesPage/CarDamagesPage';

import { Path } from 'shared/consts/Path';

import 'pages/Car/Damages/ui/CarDamagesPage/CarDamagesPage.story.global.css';

const storybookMeta = createStorybookMeta({
    title: 'pages/Car/Damages/CarDamagesPage',
    component: CarDamagesPage,

    parameters: {
        flags: { car_damage: true },
    },

    args: {
        storybookClassName: 'sb-car-damages-page',
        storybookWidth: '100vw',
    },

    decorators: [withStorybookRouter()],

    loaders: [withRequestCacheLoader],
});

export default storybookMeta;

const Template = createStorybookTemplate<{ id: string }>(({ id, ...otherProps }) => {
    return (
        <MemoryRouter initialEntries={[`/cars/${id}/damages`]}>
            <Route path={Path.CAR_DAMAGES}>
                <CarDamagesPage {...otherProps} />
            </Route>
        </MemoryRouter>
    );
});

export const normal = Template.bind({});
normal.args = { id: '694ea8ae-37c1-4912-8503-a31f12fa25e7' };

export const empty = Template.bind({});
empty.args = { id: '38ce6b44-6ee6-d397-42c5-ec0b495d2af6' };
