import * as React from 'react';
import { useParams } from 'react-router-dom';

import { CarHeader } from 'widgets/CarHeader/ui/CarHeader/CarHeader';

import { CarDamages } from 'features/CarDamages';

import { useCar } from 'entities/Car/api/useCar/useCar';
import { useCarDamages } from 'entities/Car/api/useCarDamage/useCarDamages';
import { CarNotFound } from 'entities/Car/ui/CarNotFound/CarNotFound';

import { ContentContainer } from 'shared/ui/ContentContainer/ContentContainer';
import { ErrorBoundary } from 'shared/ui/ErrorBoundary/ErrorBoundary';
import { PageLoading } from 'shared/ui/PageLoading/PageLoading';
import { SectionLayout } from 'shared/ui/SectionLayout/SectionLayout';

export const CarDamagesPage: React.FC = function CarDamagePage() {
    const { id } = useParams<{ id: string }>();

    const carResource = useCar({ carId: id });
    const carDamagesResource = useCarDamages(id);

    return (
        <ErrorBoundary fallback={CarNotFound}>
            <SectionLayout
                header={<CarHeader resource={carResource} />}
                bodyScroll
            >
                <React.Suspense fallback={<PageLoading />}>
                    <ContentContainer bodyScroll>
                        <CarDamages resource={carDamagesResource} />
                    </ContentContainer>
                </React.Suspense>
            </SectionLayout>
        </ErrorBoundary>
    );
};
