import * as React from 'react';
import cn from 'classnames';

import { UseCarResource } from 'entities/Car/api/useCar/useCar';

import { IslandTheme } from 'shared/consts/IslandTheme';
import { formatNumber } from 'shared/helpers/formatNumber/formatNumber';
import { useResourceReader } from 'shared/hooks/useResourceReader/useResourceReader';
import { Island } from 'shared/ui/Island/Island';
import { WidgetResourceBoundary } from 'shared/ui/WidgetResourceBoundary/WidgetResourceBoundary';

import MileageAllInformer from 'components/Cars/CarCard/CarCardOverview/CarCardInformers/Mileage/MileageAllInformer';
import MotoHoursAllInformer from 'components/Cars/CarCard/CarCardOverview/CarCardInformers/MotorHours/MotorHoursAllInformer';
import { CharType } from 'components/Informer';

import { i18n } from 'pages/Car/Overview/ui/CarInformersOverview/CarInformersOverview.i18n';

import styles from 'pages/Car/Overview/ui/CarInformersOverview/CarInformersOverview.css';

export interface CarInformersOverviewProps {
    resource: UseCarResource;
}

export const CarInformersOverview: React.FC<CarInformersOverviewProps> = function CarInformersOverview({ resource }) {
    const car = useResourceReader(resource);
    const { id, signalq, telematics } = car || {};
    const { mileage = null } = telematics || {};
    const [avgHours, setAvgHours] = React.useState<number>(0);

    if (!car || signalq) {
        return null;
    }

    return (
        <div className={cn(styles.informers)}>
            <WidgetResourceBoundary>
                <Island>
                    <Island
                        title={i18n('Mileage')}
                        theme={IslandTheme.GRAY}
                    >
                        <div className={styles.informerValue}>
                            {formatNumber(mileage, {
                                minimumFractionDigits: 0,
                                maximumFractionDigits: 0,
                            })}
                            &nbsp;
                            {i18n('km')}
                        </div>
                    </Island>

                    {/*@TODO DRIVEMATICSDEV-380*/}
                    <MileageAllInformer
                        className={styles.informer}
                        car_id={id}
                        type={CharType.line}
                        hideHeader
                    />
                </Island>
            </WidgetResourceBoundary>

            <WidgetResourceBoundary>
                <Island>
                    <Island
                        title={i18n('Engine hours')}
                        theme={IslandTheme.GRAY}
                    >
                        <div className={styles.informerValue}>
                            {formatNumber(avgHours, {
                                minimumFractionDigits: 1,
                                maximumFractionDigits: 1,
                            })}
                            &nbsp;
                            {i18n('h')}
                        </div>
                    </Island>

                    {/*@TODO DRIVEMATICSDEV-381*/}
                    <MotoHoursAllInformer
                        setMax={setAvgHours}
                        className={styles.informer}
                        car_id={id}
                        type={CharType.bar}
                        hideHeader
                    />
                </Island>
            </WidgetResourceBoundary>
        </div>
    );
};
