import * as React from 'react';

import { isCarMaintenanceFlag } from 'utils/isCarMaintenanceFlag';

import { CarMaintenance } from 'features/CarMaintenance';

import { UseCarResource } from 'entities/Car/api/useCar/useCar';

import { useResourceReader } from 'shared/hooks/useResourceReader/useResourceReader';
import { Widget } from 'shared/ui/Widget/Widget';

export interface CarMaintenanceOverviewProps {
    resource: UseCarResource;
}

export const CarMaintenanceOverview: React.FC<CarMaintenanceOverviewProps> = function CarMaintenanceOverview({
    resource,
}) {
    const car = useResourceReader(resource);
    const vin = car && car.vin;

    return isCarMaintenanceFlag() && vin ? (
        <Widget>
            <CarMaintenance vin={vin} />
        </Widget>
    ) : null;
};
