import * as React from 'react';

import { CarHardware } from 'features/CarHardware';
import { CarLocation } from 'features/CarLocation';

import { UseCarResource } from 'entities/Car/api/useCar/useCar';
import { UseCarBeaconResource } from 'entities/Car/api/useCarBeacon/useCarBeacon';

import { useResourceReader } from 'shared/hooks/useResourceReader/useResourceReader';
import { WidgetResourceBoundary } from 'shared/ui/WidgetResourceBoundary/WidgetResourceBoundary';

export interface CarOverviewProps {
    className?: string;

    carResource: UseCarResource;
    beaconResource?: UseCarBeaconResource;

    onHardwareChange?(): void;
}

export const CarOverview: React.FC<CarOverviewProps> = function CarOverview({
    className,
    carResource,
    beaconResource,
    onHardwareChange,
}) {
    const beacon = useResourceReader(beaconResource);
    const car = useResourceReader(carResource);

    if (beacon && beaconResource) {
        return (
            <>
                <div className={className}>
                    <WidgetResourceBoundary>
                        {car && (
                            <CarLocation
                                resource={carResource}
                                beaconResource={beaconResource}
                            />
                        )}
                    </WidgetResourceBoundary>
                </div>
                <div className={className}>
                    <WidgetResourceBoundary>
                        <CarHardware
                            resource={carResource}
                            beaconResource={beaconResource}
                            onHardwareChange={onHardwareChange}
                        />
                    </WidgetResourceBoundary>
                </div>
            </>
        );
    }

    return (
        <>
            <div className={className}>
                <WidgetResourceBoundary>
                    <CarHardware
                        resource={carResource}
                        onHardwareChange={onHardwareChange}
                    />
                </WidgetResourceBoundary>
            </div>
        </>
    );
};
