import * as React from 'react';
import { MemoryRouter, Route } from 'react-router-dom';

import { withStorybookRouter } from 'tests/storybook/decorators/withStorybookRouter';
import { createStorybookMeta } from 'tests/storybook/helpers/createStorybookMeta';
import { createStorybookTemplate } from 'tests/storybook/helpers/createStorybookTemplate';
import { withRequestCacheLoader } from 'tests/storybook/loaders/withRequestCacheLoader';

import { CarOverviewPage } from 'pages/Car/Overview/ui/CarOverviewPage/CarOverviewPage';

import { Path } from 'shared/consts/Path';

const storybookMeta = createStorybookMeta({
    title: 'pages/Car/Overview/CarOverviewPage',
    component: CarOverviewPage,

    args: {
        storybookWidth: '100vw',
    },

    parameters: { date: new Date('2022-05-18') },

    hermioneOptions: { ignoreElements: ['[data-testid="map"]', '[data-testid="address"]'] },

    decorators: [withStorybookRouter()],

    loaders: [withRequestCacheLoader],
});

export default storybookMeta;

const Template = createStorybookTemplate((props) => {
    return (
        <MemoryRouter initialEntries={['/cars/000c7f42-fa23-8c5c-216f-d1faeb1743c5/overview']}>
            <Route path={Path.CAR_OVERVIEW}>
                <CarOverviewPage {...props} />
            </Route>
        </MemoryRouter>
    );
});

export const normal = Template.bind({});
normal.args = {};

export const notFound = Template.bind({});
notFound.args = {};
notFound.parameters = {
    cacheName: 'load-error',
};

export const beaconError = Template.bind({});
beaconError.args = {};
beaconError.parameters = {
    cacheName: 'beacon-load-error',
};

export const signalsError = Template.bind({});
signalsError.args = {};
signalsError.parameters = {
    cacheName: 'signals-load-error',
};

export const ridesError = Template.bind({});
ridesError.args = {};
ridesError.parameters = {
    cacheName: 'rides-load-error',
};
