import * as React from 'react';
import { useParams } from 'react-router-dom';

import { ONE_SECOND } from 'constants/constants';

import { CarLayoutOverview } from 'pages/Car/Overview/ui/CarLayoutOverview/CarLayoutOverview';

import { CarHeader } from 'widgets/CarHeader/ui/CarHeader/CarHeader';

import { useCar } from 'entities/Car/api/useCar/useCar';
import { CarNotFound } from 'entities/Car/ui/CarNotFound/CarNotFound';

import { useResourceReloader } from 'shared/hooks/useResourceReloader/useResourceReloader';
import { ErrorBoundary } from 'shared/ui/ErrorBoundary/ErrorBoundary';
import { PageLoading } from 'shared/ui/PageLoading/PageLoading';
import { SectionLayout } from 'shared/ui/SectionLayout/SectionLayout';

export const CarOverviewPage: React.FC = function CarOverviewPage() {
    const { id } = useParams<{ id: string }>();

    const carResource = useCar({
        carId: id,
        sensors: ['speed', 'mileage', 'fuel_level', 'fuel_distance', 'ext_voltage', 'engine_on', 'gsm_signal_level'],
    });

    useResourceReloader(carResource, ONE_SECOND);

    return (
        <ErrorBoundary fallback={CarNotFound}>
            <SectionLayout
                header={<CarHeader resource={carResource} />}
                bodyScroll
            >
                <React.Suspense fallback={<PageLoading />}>
                    <CarLayoutOverview
                        id={id}
                        carResource={carResource}
                    />
                </React.Suspense>
            </SectionLayout>
        </ErrorBoundary>
    );
};
