import * as React from 'react';
import { Redirect, useLocation, useParams } from 'react-router-dom';

import { CarCardTab } from 'entities/Car/consts/CarCardTab';

import { Path } from 'shared/consts/Path';
import { generateRouterPath } from 'shared/helpers/generateRouterPath/generateRouterPath';

export interface CarRedirectPageProps {}

const CARD_TAB = 'card_tab';
export const CAR_HEADER_TAB_ROUTES: Record<CarCardTab, Path> = {
    [CarCardTab.OVERVIEW]: Path.CAR_OVERVIEW,
    [CarCardTab.SIGNALS]: Path.CAR_SIGNALS,
    [CarCardTab.SESSIONS]: Path.CAR_RIDES,
    [CarCardTab.TELEMATICS]: Path.CAR_TELEMATICS,
    [CarCardTab.DAMAGES]: Path.CAR_DAMAGES,
};

export const CarRedirectPage: React.FC<CarRedirectPageProps> = function CarRedirectPage({}) {
    const location = useLocation();
    const params = useParams();

    const searchParams = new URLSearchParams(location.search);
    const tab = searchParams.get(CARD_TAB) || CarCardTab.OVERVIEW;

    return (
        <Redirect
            exact
            from={Path.CAR}
            to={{
                pathname: generateRouterPath(CAR_HEADER_TAB_ROUTES[tab], params),
            }}
        />
    );
};
