import * as React from 'react';
import { useState } from 'react';
import { useParams } from 'react-router-dom';

import { CarHeader } from 'widgets/CarHeader/ui/CarHeader/CarHeader';
import { HEADER_HEIGHT } from 'widgets/Header';
import { SignalsContentHeader } from 'widgets/SignalsContentHeader';
import { SignalsFilters } from 'widgets/SignalsFilters';
import { SignalsTableWidget } from 'widgets/SignalsTableWidget';

import { useCar } from 'entities/Car/api/useCar/useCar';
import { CarNotFound } from 'entities/Car/ui/CarNotFound/CarNotFound';
import { useSignalList } from 'entities/Signal/api/useSignalList/useSignalList';
import { INITIAL_SIGNALS_FILTERS } from 'entities/Signal/consts/filters';

import { ContentContainer } from 'shared/ui/ContentContainer/ContentContainer';
import { ErrorBoundary } from 'shared/ui/ErrorBoundary/ErrorBoundary';
import { PageLoading } from 'shared/ui/PageLoading/PageLoading';
import { SectionLayout } from 'shared/ui/SectionLayout/SectionLayout';
import { Widget } from 'shared/ui/Widget/Widget';

import { SignalsFiltersOptions } from 'components/Signals';

export interface CarSignalsPageProps {
    className?: string;
}

export const CarSignalsPage: React.FC<CarSignalsPageProps> = function CarSignalsPage({ className }) {
    const { id } = useParams<{ id: string }>();

    const carResource = useCar({
        carId: id,
        sensors: ['speed', 'mileage', 'fuel_level', 'fuel_distance', 'ext_voltage', 'engine_on', 'gsm_signal_level'],
    });

    const [filters, setFilters] = useState<SignalsFiltersOptions>(INITIAL_SIGNALS_FILTERS);
    const { data, isFullyLoaded, isLoading, fetchNextPage } = useSignalList({
        ...filters,
        cars_ids: id,
    });

    return (
        <ErrorBoundary fallback={CarNotFound}>
            <SectionLayout
                header={<CarHeader resource={carResource} />}
                filters={
                    <SignalsFilters
                        offsetTop={HEADER_HEIGHT}
                        onFiltersChange={setFilters}
                    />
                }
                bodyScroll
            >
                <React.Suspense fallback={<PageLoading />}>
                    <ContentContainer bodyScroll>
                        <Widget contentContainer>
                            <SignalsContentHeader
                                filters={{
                                    ...filters,
                                    cars_ids: id,
                                }}
                            />

                            <SignalsTableWidget
                                data={data}
                                isFullyLoaded={isFullyLoaded}
                                isLoading={isLoading}
                                fetchNextPage={fetchNextPage}
                                isOneCar
                            />
                        </Widget>
                    </ContentContainer>
                </React.Suspense>
            </SectionLayout>
        </ErrorBoundary>
    );
};
