import { i18n as i18nBuilder, keyset, MovaLang, plurals } from 'mova-i18n';

const translates = keyset({
    'Behavior and security': {
        en: 'Behavior and security',
        ru: 'Поведение и безопасность',
        cs: '',
    },
    Dashboard: {
        _meta: {
            status: {
                en: 'APPROVED',
                ru: 'REQUIRES_TRANSLATION',
                cs: 'APPROVED',
            },
        },
        en: 'Dashboard',
        ru: 'Дашборд',
        cs: 'Informační panel',
    },
    'Realtime states': {
        _meta: {
            status: {
                en: 'REQUIRES_TRANSLATION',
                ru: 'REQUIRES_TRANSLATION',
                cs: 'APPROVED',
            },
        },
        en: 'Realtime states',
        ru: 'Состояния в реальном времени',
        cs: 'Stavy v reálném čase',
    },
    'Something went wrong': {
        _meta: {
            status: {
                en: 'APPROVED',
                ru: 'REQUIRES_TRANSLATION',
                cs: 'APPROVED',
            },
        },
        en: 'Something went wrong',
        ru: 'Что-то пошло не так',
        cs: 'Něco se pokazilo',
    },
    "Try to reload the page, if it doesn't help - try to come back later": {
        _meta: {
            status: {
                en: 'APPROVED',
                ru: 'REQUIRES_TRANSLATION',
                cs: 'APPROVED',
            },
        },
        en: "Try to reload the page, if it doesn't help - try to come back later",
        ru: 'Попробуйте перезагрузить страницу, если не поможет — попробуйте зайти попозже',
        cs: 'Zkuste stránku znovu načíst, a pokud to nepomůže, zkuste se vrátit později',
    },
    'Utilization and efficiency': {
        _meta: {
            status: {
                en: 'REQUIRES_TRANSLATION',
                ru: 'REQUIRES_TRANSLATION',
                cs: 'APPROVED',
            },
        },
        en: 'Utilization and efficiency',
        ru: 'Использование и эффективность',
        cs: 'Využití a efektivita',
    },
});

export const i18n = i18nBuilder(process.env.LANG as MovaLang, plurals)(translates);
