import { withStorybookRouter } from 'tests/storybook/decorators/withStorybookRouter';
import { createStorybookMeta } from 'tests/storybook/helpers/createStorybookMeta';
import { createStorybookTemplate } from 'tests/storybook/helpers/createStorybookTemplate';
import { withRequestCacheLoader } from 'tests/storybook/loaders/withRequestCacheLoader';

import Dashboard from 'pages/Dashboard/Dashboard/index';
import { DashboardProps } from 'pages/Dashboard/Dashboard/ui/Dashboard/Dashboard';

const storybookMeta = createStorybookMeta<DashboardProps>({
    title: 'pages/Dashboard/Dashboard/Dashboard',
    component: Dashboard,

    parameters: {
        date: new Date('2022-04-01'),
    },

    args: {
        storybookWidth: '100vw',
    },

    decorators: [withStorybookRouter()],
    loaders: [withRequestCacheLoader],
});

export default storybookMeta;

const Template = createStorybookTemplate<DashboardProps>(Dashboard);

export const emptyData = Template.bind({});
emptyData.args = {};
