import { i18n as i18nBuilder, keyset, MovaLang, plurals } from 'mova-i18n';

const translates = keyset({
    Car: {
        _meta: {
            status: {
                en: 'APPROVED',
                ru: 'REQUIRES_TRANSLATION',
                cs: 'APPROVED',
            },
        },
        en: 'Car',
        ru: 'Машина',
        cs: 'Vůz',
    },
    'Engine hours utilisation, %': {
        _meta: {
            status: {
                en: 'APPROVED',
                ru: 'EXPIRED',
                cs: 'REQUIRES_TRANSLATION',
            },
        },
        en: 'Engine hours utilisation, %',
        ru: 'Утилизация по моточасам, %',
        cs: 'Průměrné využití, %',
    },
    h: {
        _meta: {
            status: {
                en: 'APPROVED',
                ru: 'APPROVED',
                cs: 'APPROVED',
            },
        },
        en: 'h',
        ru: 'ч',
        cs: 'h',
    },
    km: {
        _meta: {
            status: {
                en: 'APPROVED',
                ru: 'APPROVED',
                cs: 'APPROVED',
            },
        },
        en: 'km',
        ru: 'км',
        cs: 'km',
    },
    'Top cars by eng. hours': {
        _meta: {
            status: {
                en: 'REQUIRES_TRANSLATION',
                ru: 'REQUIRES_TRANSLATION',
                cs: 'APPROVED',
            },
        },
        en: 'Top cars by eng. hours',
        ru: 'Лучшие машины по моточасам',
        cs: 'Nejlepší auta podle moto. hodin',
    },
    'Top cars by mileage': {
        _meta: {
            status: {
                en: 'REQUIRES_TRANSLATION',
                ru: 'REQUIRES_TRANSLATION',
                cs: 'APPROVED',
            },
        },
        en: 'Top cars by mileage',
        ru: 'Лучшие машины по пробегу',
        cs: 'Nejlepší auta podle najetých kilometrů',
    },
    'Top cars by utilisation': {
        _meta: {
            status: {
                en: 'REQUIRES_TRANSLATION',
                ru: 'REQUIRES_TRANSLATION',
                cs: 'APPROVED',
            },
        },
        en: 'Top cars by utilisation',
        ru: 'Лучшие машины по утилизации',
        cs: 'Nejlepší auta podle využití',
    },
    'Total engine hours': {
        _meta: {
            status: {
                en: 'REQUIRES_TRANSLATION',
                ru: 'REQUIRES_TRANSLATION',
                cs: 'APPROVED',
            },
        },
        en: 'Total engine hours',
        ru: 'Всего моточасов',
        cs: 'Celkem motohodin',
    },
    'Total for the period': {
        _meta: {
            status: {
                en: 'REQUIRES_TRANSLATION',
                ru: 'REQUIRES_TRANSLATION',
                cs: 'APPROVED',
            },
        },
        en: 'Total for the period',
        ru: 'Всего за период',
        cs: 'Celkem za období',
    },
    'Total mileage, km': {
        _meta: {
            status: {
                en: 'REQUIRES_TRANSLATION',
                ru: 'REQUIRES_TRANSLATION',
                cs: 'APPROVED',
            },
        },
        en: 'Total mileage, km',
        ru: 'Всего пробег, км',
        cs: 'Celkový počet kilometrů, km',
    },
    'Worst cars by eng. hours': {
        _meta: {
            status: {
                en: 'REQUIRES_TRANSLATION',
                ru: 'REQUIRES_TRANSLATION',
                cs: 'APPROVED',
            },
        },
        en: 'Worst cars by eng. hours',
        ru: 'Худшие машины по моточасам',
        cs: 'Nejhorší auta podle motohodin',
    },
    'Worst cars by mileage': {
        _meta: {
            status: {
                en: 'REQUIRES_TRANSLATION',
                ru: 'REQUIRES_TRANSLATION',
                cs: 'APPROVED',
            },
        },
        en: 'Worst cars by mileage',
        ru: 'Худшие машины по пробегу',
        cs: 'Nejhorší auta podle najetých kilometrů',
    },
    'Worst cars by utilisation': {
        _meta: {
            status: {
                en: 'REQUIRES_TRANSLATION',
                ru: 'REQUIRES_TRANSLATION',
                cs: 'APPROVED',
            },
        },
        en: 'Worst cars by utilisation',
        ru: 'Худшие машины по утилизации',
        cs: 'Nejhorší auta podle využití',
    },
});

export const i18n = i18nBuilder(process.env.LANG as MovaLang, plurals)(translates);
