import { withStorybookRouter } from 'tests/storybook/decorators/withStorybookRouter';
import { createStorybookMeta } from 'tests/storybook/helpers/createStorybookMeta';
import { createStorybookTemplate } from 'tests/storybook/helpers/createStorybookTemplate';
import { withRequestCacheLoader } from 'tests/storybook/loaders/withRequestCacheLoader';

import { EfficiencyBoard, EfficiencyBoardProps } from 'pages/Dashboard/Dashboard/ui/EfficiencyBoard/EfficiencyBoard';

import { CarTop } from 'entities/Ride/api/useRidesSummary/useRidesSummary';

import { DateAggregation } from 'shared/consts/DateAggregation';
import { ChartPoint } from 'shared/types/ChartPoint';

const storybookMeta = createStorybookMeta<EfficiencyBoardProps>({
    title: 'pages/Dashboard/Dashboard/EfficiencyBoard',
    component: EfficiencyBoard,

    args: {
        storybookWidth: '1008px',
    },

    decorators: [withStorybookRouter()],

    loaders: [withRequestCacheLoader],
});

export default storybookMeta;

const Template = createStorybookTemplate<EfficiencyBoardProps>(EfficiencyBoard);

const TOP: CarTop[] = [
    {
        object_id: 'id1',
        number: '8 AUX 14',
        name: 'BMW x5',
        model_id: 'bmw_x5',
        value: 100,
    },
];
const POINTS: ChartPoint[] = [
    {
        begin_date: 1634158800000,
        end_date: 1634245200000,
        line1: 50,
    },
    {
        begin_date: 1634245200000,
        end_date: 1634331600000,
        line1: 5,
    },
    {
        begin_date: 1634331600000,
        end_date: 1634418000000,
        line1: 150,
    },
    {
        begin_date: 1634418000000,
        end_date: 1634504400000,
        line1: 250,
    },
];

export const normal = Template.bind({});
normal.args = {
    cars: {
        id1: {
            number: '8 AUX 14',
            modelName: 'BMW x5',
        },
    },
    summary: {
        topMileageCars: TOP,
        worseMileageCars: TOP,

        topHoursCars: TOP,
        worseHoursCars: TOP,

        topUtilizationCars: TOP,
        worseUtilizationCars: TOP,

        mileageChartPoints: POINTS,
        hoursChartPoints: POINTS,
        utilizationChartPoints: POINTS,

        averageDurationByTime: 200,
        averageMileageByTime: 300,
        averageFleetUtilization: 400,
        averageRentalUtilization: 400,
        totalDuration: 500,
        totalMileage: 1000,
    },
    aggregationConfig: {
        aggregation: DateAggregation.DAY,
    },
};
export const loading = Template.bind({});
loading.args = {
    cacheName: 'loading',
    isLoading: true,
    cars: {},
    aggregationConfig: {
        aggregation: DateAggregation.DAY,
    },
};
