import { withStorybookRouter } from 'tests/storybook/decorators/withStorybookRouter';
import { createStorybookMeta } from 'tests/storybook/helpers/createStorybookMeta';
import { createStorybookTemplate } from 'tests/storybook/helpers/createStorybookTemplate';
import { withRequestCacheLoader } from 'tests/storybook/loaders/withRequestCacheLoader';

import { StateBoard, StateBoardProps } from 'pages/Dashboard/Dashboard/ui/StateBoard/StateBoard';

import { CarStatusType } from 'entities/Car/consts/CarStatusType';

const storybookMeta = createStorybookMeta<StateBoardProps>({
    title: 'pages/Dashboard/Dashboard/StateBoard',
    component: StateBoard,

    args: {
        storybookWidth: '968px',
    },

    decorators: [withStorybookRouter()],

    loaders: [withRequestCacheLoader],
});

export default storybookMeta;

const Template = createStorybookTemplate<StateBoardProps>(StateBoard);

export const normal = Template.bind({});
normal.args = {
    statuses: {
        [CarStatusType.RIDING]: 5,
        [CarStatusType.ENGINE_ON]: 5,
        [CarStatusType.ENGINE_OFF]: 5,
        [CarStatusType.DELAYED_UNBLOCK]: 5,
        [CarStatusType.DELAYED_BLOCK]: 1,
        [CarStatusType.BLOCKED]: 9,
    },
    totalCars: 30,
};
export const loading = Template.bind({});
loading.args = {
    isLoading: true,
};
