import { i18n as i18nBuilder, keyset, MovaLang, plurals } from 'mova-i18n';

const translates = keyset({
    'Avg. booking duration': {
        _meta: {
            status: {
                en: 'REQUIRES_TRANSLATION',
                ru: 'REQUIRES_TRANSLATION',
                cs: 'APPROVED',
            },
        },
        en: 'Avg. booking duration',
        ru: 'Сред. длительность бронирования',
        cs: 'Průměrná doba rezervace',
    },
    'Avg. for the period': {
        _meta: {
            status: {
                en: 'REQUIRES_TRANSLATION',
                ru: 'REQUIRES_TRANSLATION',
                cs: 'APPROVED',
            },
        },
        en: 'Avg. for the period',
        ru: 'Сред. за период',
        cs: 'Průměr za období',
    },
    Car: {
        _meta: {
            status: {
                en: 'APPROVED',
                ru: 'REQUIRES_TRANSLATION',
                cs: 'APPROVED',
            },
        },
        en: 'Car',
        ru: 'Машина',
        cs: 'Vůz',
    },
    'Number of bookings': {
        _meta: {
            status: {
                en: 'REQUIRES_TRANSLATION',
                ru: 'REQUIRES_TRANSLATION',
                cs: 'APPROVED',
            },
        },
        en: 'Number of bookings',
        ru: 'Количество бронирований',
        cs: 'Počet rezervací',
    },
    'Top cars by utilisation': {
        _meta: {
            context: 'Booking efficiency',
            group: '1',
            status: {
                en: 'REQUIRES_TRANSLATION',
                ru: 'REQUIRES_TRANSLATION',
                cs: 'APPROVED',
            },
        },
        en: 'Top cars by utilisation',
        ru: 'Лучшие машины по сдаваемости',
        cs: 'Nejlepší auta podle využití',
    },
    'Total for the period': {
        _meta: {
            status: {
                en: 'REQUIRES_TRANSLATION',
                ru: 'REQUIRES_TRANSLATION',
                cs: 'APPROVED',
            },
        },
        en: 'Total for the period',
        ru: 'Всего за период',
        cs: 'Celkem za období',
    },
    'Total rental days': {
        _meta: {
            status: {
                en: 'REQUIRES_TRANSLATION',
                ru: 'REQUIRES_TRANSLATION',
                cs: 'APPROVED',
            },
        },
        en: 'Total rental days',
        ru: 'Всего дней аренды',
        cs: 'Celkem dnů pronájmu',
    },
    Utilisation: {
        _meta: {
            context: 'Booking efficiency',
            group: '1',
            status: {
                en: 'REQUIRES_TRANSLATION',
                ru: 'REQUIRES_TRANSLATION',
                cs: 'APPROVED',
            },
        },
        en: 'Utilisation',
        ru: 'Сдаваемость',
        cs: 'Využití',
    },
    'Worst cars by utilisation': {
        _meta: {
            context: 'Booking efficiency',
            group: '1',
            status: {
                en: 'REQUIRES_TRANSLATION',
                ru: 'REQUIRES_TRANSLATION',
                cs: 'APPROVED',
            },
        },
        en: 'Worst cars by utilisation',
        ru: 'Худшие машины по сдаваемости',
        cs: 'Nejhorší auta podle využití',
    },
});

export const i18n = i18nBuilder(process.env.LANG as MovaLang, plurals)(translates);
