import { i18n as i18nBuilder, keyset, MovaLang, plurals } from 'mova-i18n';

const translates = keyset({
    '{count} car': {
        _meta: {
            status: {
                en: 'APPROVED',
                ru: 'REQUIRES_TRANSLATION',
                cs: 'APPROVED',
            },
        },
        en: {
            one: '{count} car',
            other: '{count} cars',
            zero: 'No cars',
        },
        ru: {
            one: '{count} машина',
            few: '{count} машины',
            many: '{count} машин',
            zero: 'Нет машин',
        },
        cs: {
            one: '{count} auto',
            few: '{count} auta',
            other: '{count} aut',
            zero: 'Žádná auta',
        },
    },
    Free: {
        _meta: {
            status: {
                en: 'REQUIRES_TRANSLATION',
                ru: 'REQUIRES_TRANSLATION',
                cs: 'APPROVED',
            },
        },
        en: 'Free',
        ru: 'Свободные',
        cs: 'Volné',
    },
    'In rent': {
        _meta: {
            status: {
                en: 'REQUIRES_TRANSLATION',
                ru: 'REQUIRES_TRANSLATION',
                cs: 'APPROVED',
            },
        },
        en: 'In rent',
        ru: 'В аренде',
        cs: 'V pronajmu',
    },
    'In service': {
        _meta: {
            status: {
                en: 'REQUIRES_TRANSLATION',
                ru: 'REQUIRES_TRANSLATION',
                cs: 'APPROVED',
            },
        },
        en: 'In service',
        ru: 'В сервисе',
        cs: 'V servisu',
    },
    Now: {
        _meta: {
            status: {
                en: 'REQUIRES_TRANSLATION',
                ru: 'REQUIRES_TRANSLATION',
                cs: 'APPROVED',
            },
        },
        en: 'Now',
        ru: 'Сейчас',
        cs: 'Teď',
    },
});

export const i18n = i18nBuilder(process.env.LANG as MovaLang, plurals)(translates);
