import { i18n as i18nBuilder, keyset, MovaLang, plurals } from 'mova-i18n';

const translates = keyset({
    Bookings: {
        _meta: {
            status: {
                en: 'REQUIRES_TRANSLATION',
                ru: 'REQUIRES_TRANSLATION',
                cs: 'APPROVED',
            },
        },
        en: 'Bookings',
        ru: 'Бронирования',
        cs: 'Seznam rezervací',
    },
    Dashboard: {
        _meta: {
            status: {
                en: 'APPROVED',
                ru: 'REQUIRES_TRANSLATION',
                cs: 'APPROVED',
            },
        },
        en: 'Dashboard',
        ru: 'Дашборд',
        cs: 'Informační panel',
    },
    'Fleet utilization': {
        _meta: {
            status: {
                en: 'REQUIRES_TRANSLATION',
                ru: 'REQUIRES_TRANSLATION',
                cs: 'APPROVED',
            },
        },
        en: 'Fleet utilization',
        ru: 'Утилизация парка',
        cs: 'Využití vozového parku',
    },
    'Realtime states': {
        _meta: {
            status: {
                en: 'REQUIRES_TRANSLATION',
                ru: 'REQUIRES_TRANSLATION',
                cs: 'APPROVED',
            },
        },
        en: 'Realtime states',
        ru: 'Состояния в реальном времени',
        cs: 'Stavy v reálném čase',
    },
    Revenue: {
        _meta: {
            status: {
                en: 'REQUIRES_TRANSLATION',
                ru: 'REQUIRES_TRANSLATION',
                cs: 'APPROVED',
            },
        },
        en: 'Revenue',
        ru: 'Доход',
        cs: 'Příjmy',
    },
});

export const i18n = i18nBuilder(process.env.LANG as MovaLang, plurals)(translates);
