import { withStorybookRouter } from 'tests/storybook/decorators/withStorybookRouter';
import { createStorybookMeta } from 'tests/storybook/helpers/createStorybookMeta';
import { createStorybookTemplate } from 'tests/storybook/helpers/createStorybookTemplate';
import { withRequestCacheLoader } from 'tests/storybook/loaders/withRequestCacheLoader';

import {
    DashboardRental,
    DashboardRentalProps,
} from 'pages/Dashboard/DashboardRental/ui/DashboardRental/DashboardRental';

const storybookMeta = createStorybookMeta<DashboardRentalProps>({
    title: 'pages/Dashboard/DashboardRental/DashboardRental',
    component: DashboardRental,

    parameters: {
        date: new Date('2022-04-01'),
    },

    args: {
        storybookWidth: '100vw',
    },

    decorators: [withStorybookRouter()],
    loaders: [withRequestCacheLoader],
});

export default storybookMeta;

const Template = createStorybookTemplate<DashboardRentalProps>(DashboardRental);

export const emptyData = Template.bind({});
emptyData.args = {};
