import * as React from 'react';

import { Header } from 'widgets/Header';

import { NotificationsTelegram } from 'features/NotificationsTelegram';
import { SettingsHeaderTabs } from 'features/SettingsHeaderTabs';

import { ContentContainer } from 'shared/ui/ContentContainer/ContentContainer';
import { Island } from 'shared/ui/Island/Island';
import { SectionLayout } from 'shared/ui/SectionLayout/SectionLayout';

import { i18n } from 'pages/Settings/Notifications/ui/SettingsNotificationsPage/SettingsNotificationsPage.i18n';

import styles from 'pages/Settings/Notifications/ui/SettingsNotificationsPage/SettingsNotificationsPage.css';

export interface SettingsNotificationsPageProps {}

export const SettingsNotificationsPage: React.FC<SettingsNotificationsPageProps> =
    function SettingsNotificationsPage({}) {
        return (
            <SectionLayout
                header={
                    <Header
                        title={i18n('Settings')}
                        tabs={<SettingsHeaderTabs />}
                        withoutBorder
                    />
                }
                bodyScroll
            >
                <ContentContainer
                    className={styles.content}
                    bodyScroll
                >
                    <Island title={i18n('Telegram')}>
                        <NotificationsTelegram />
                    </Island>
                </ContentContainer>
            </SectionLayout>
        );
    };
