import { i18n as i18nBuilder, keyset, MovaLang, plurals } from 'mova-i18n';

const translates = keyset({
    'Add-ons': {
        en: 'Add-ons',
        ru: 'Дополнения',
        cs: '',
    },
    'Daily rates': {
        en: 'Daily rates',
        ru: 'Дневные тарифы',
        cs: '',
    },
    Deposits: {
        en: 'Deposits',
        ru: 'Депозиты',
        cs: '',
    },
    Insurance: {
        _meta: {
            status: {
                en: 'APPROVED',
                ru: 'REQUIRES_TRANSLATION',
                cs: 'APPROVED',
            },
        },
        en: 'Insurance',
        ru: 'Страхование',
        cs: 'Pojištění',
    },
    Limits: {
        en: 'Limits',
        ru: 'Лимиты',
        cs: '',
    },
    Policies: {
        en: 'Policies',
        ru: 'Полисы',
        cs: '',
    },
    Settings: {
        _meta: {
            status: {
                en: 'APPROVED',
                ru: 'REQUIRES_TRANSLATION',
                cs: 'APPROVED',
            },
        },
        en: 'Settings',
        ru: 'Настройки',
        cs: 'Nastavení',
    },
});

export const i18n = i18nBuilder(process.env.LANG as MovaLang, plurals)(translates);
