import * as React from 'react';

import { Header } from 'widgets/Header';

import { SettingsDailyRates } from 'features/SettingsDailyRates';
import { SettingsHeaderTabs } from 'features/SettingsHeaderTabs';

import { useCarOfferPricing } from 'entities/Car/api/useCarOfferPricing/useCarOfferPricing';

import { TabSize } from 'shared/consts/TabSize';
import { ContentContainer } from 'shared/ui/ContentContainer/ContentContainer';
import { ErrorBoundary } from 'shared/ui/ErrorBoundary/ErrorBoundary';
import { PageLoading } from 'shared/ui/PageLoading/PageLoading';
import { SectionLayout } from 'shared/ui/SectionLayout/SectionLayout';
import { TabItemOptions } from 'shared/ui/TabItem/TabItem';
import { Tabs } from 'shared/ui/Tabs/Tabs';
import { Widget } from 'shared/ui/Widget/Widget';

import { i18n } from 'pages/Settings/Pricing/ui/PricingPage/PricingPage.i18n';

import styles from 'pages/Settings/Pricing/ui/PricingPage/PricingPage.css';

enum PricingTabsValue {
    DAILY_RATES = 'daily_rates',
    ADD_ONS = 'add_ons',
    INSURANCE = 'insurance',
    DEPOSITS = 'deposits',
    LIMITS = 'limits',
    POLICIES = 'policies',
}

const PRICING_TABS_ITEMS: TabItemOptions[] = [
    { label: i18n('Daily rates'), value: PricingTabsValue.DAILY_RATES },
    { label: i18n('Add-ons'), value: PricingTabsValue.ADD_ONS, disabled: true },
    { label: i18n('Insurance'), value: PricingTabsValue.INSURANCE, disabled: true },
    { label: i18n('Deposits'), value: PricingTabsValue.DEPOSITS, disabled: true },
    { label: i18n('Limits'), value: PricingTabsValue.LIMITS, disabled: true },
    { label: i18n('Policies'), value: PricingTabsValue.POLICIES, disabled: true },
];

export const PricingPage = function PricingPage() {
    const resource = useCarOfferPricing();

    return (
        <ErrorBoundary fallback={null}>
            <React.Suspense fallback={<PageLoading />}>
                <SectionLayout
                    header={
                        <Header
                            title={i18n('Settings')}
                            tabs={<SettingsHeaderTabs />}
                            withoutBorder
                        />
                    }
                    bodyScroll
                >
                    <ContentContainer bodyScroll>
                        <Widget
                            className={styles.wrap}
                            contentContainer
                        >
                            <Tabs
                                className={styles.tabs}
                                size={TabSize.L}
                                items={PRICING_TABS_ITEMS}
                                currentItem={PricingTabsValue.DAILY_RATES}
                            />

                            <SettingsDailyRates
                                className={styles.body}
                                resource={resource}
                            />
                        </Widget>
                    </ContentContainer>
                </SectionLayout>
            </React.Suspense>
        </ErrorBoundary>
    );
};
