import * as React from 'react';
import { useParams } from 'react-router-dom';

import { Header } from 'widgets/Header';

import { UserDocuments } from 'features/UserDocuments';
import { UserHeaderTabs } from 'features/UserHeaderTabs';

import { UserHeaderTitle, UserNotFound, useUserMember } from 'entities/User';

import { ContentContainer } from 'shared/ui/ContentContainer/ContentContainer';
import { ErrorBoundary } from 'shared/ui/ErrorBoundary/ErrorBoundary';
import { PageLoading } from 'shared/ui/PageLoading/PageLoading';
import { SectionLayout } from 'shared/ui/SectionLayout/SectionLayout';

// @todo: add storybook test
export const UserDocumentsPage = function UserDocumentsPage() {
    const { id } = useParams<{ id: string }>();

    const userMemberResource = useUserMember(id);

    return (
        <ErrorBoundary fallback={<UserNotFound />}>
            <React.Suspense fallback={<PageLoading />}>
                <SectionLayout
                    header={
                        <Header
                            title={<UserHeaderTitle resource={userMemberResource} />}
                            tabs={<UserHeaderTabs resource={userMemberResource} />}
                            withoutBorder
                        />
                    }
                    bodyScroll
                >
                    <ContentContainer bodyScroll>
                        <UserDocuments />
                    </ContentContainer>
                </SectionLayout>
            </React.Suspense>
        </ErrorBoundary>
    );
};
