import * as React from 'react';
import { useParams } from 'react-router-dom';

import { Header } from 'widgets/Header';

import { UserDetails } from 'features/UserDetails';
import { UserHeaderTabs } from 'features/UserHeaderTabs';

import { UserHeaderTitle, UserNotFound, useUserMember } from 'entities/User';
import { useUser } from 'entities/User/api/useUser/useUser';
import { useUserPerformedTags } from 'entities/User/api/useUserPerformedTags/useUserPerformedTags';

import { ContentContainer } from 'shared/ui/ContentContainer/ContentContainer';
import { ErrorBoundary } from 'shared/ui/ErrorBoundary/ErrorBoundary';
import { PageLoading } from 'shared/ui/PageLoading/PageLoading';
import { SectionLayout } from 'shared/ui/SectionLayout/SectionLayout';

import styles from 'pages/User/Profile/ui/UserProfilePage/UserProfilePage.css';

// @todo: add storybook test
export const UserProfilePage = function UserProfilePage() {
    const { id } = useParams<{ id: string }>();

    const userResource = useUser(id);
    const userMemberResource = useUserMember(id);
    const userPerformedTagsResource = useUserPerformedTags(id);

    return (
        <ErrorBoundary fallback={<UserNotFound />}>
            <React.Suspense fallback={<PageLoading />}>
                <SectionLayout
                    header={
                        <Header
                            title={<UserHeaderTitle resource={userMemberResource} />}
                            tabs={<UserHeaderTabs resource={userMemberResource} />}
                            withoutBorder
                        />
                    }
                    bodyScroll
                >
                    <ContentContainer
                        className={styles.content}
                        bodyScroll
                    >
                        <UserDetails
                            userResource={userResource}
                            memberResource={userMemberResource}
                            performedTagsResource={userPerformedTagsResource}
                        />
                    </ContentContainer>
                </SectionLayout>
            </React.Suspense>
        </ErrorBoundary>
    );
};
