export type EventListener<T> = (event: T) => void;
export type EventListenerUnsubscribe = () => void;

export function addEventListener(
    element: HTMLElement | Window | Document | SVGRectElement,
    action: string,
    callback: EventListener<Event>,
    options?: boolean | AddEventListenerOptions,
): EventListenerUnsubscribe {
    element.addEventListener(action, callback, options);

    return () => {
        element.removeEventListener(action, callback, options);
    };
}
