/*eslint-disable @typescript-eslint/no-magic-numbers*/
import { axisLeft, axisRight } from 'd3-axis';

import { DEFAULT_CHART_HEIGHT } from 'shared/consts/Chart';
import { d3ScaleY } from 'shared/helpers/d3ScaleY/d3ScaleY';
import { formatChartValue } from 'shared/helpers/formatChartValue/formatChartValue';
import { getChartRangeValue } from 'shared/helpers/getChartRangeValue/getChartRangeValue';
import { ChartKeysFormat } from 'shared/types/ChartKeysFormat';
import { ChartKey, ChartPoint } from 'shared/types/ChartPoint';
import { D3SelectFunction } from 'shared/types/D3SelectFunction';

export function d3AxisSignature(
    points: ChartPoint[],
    key: ChartKey,
    keyFormat?: ChartKeysFormat,
    height: number = DEFAULT_CHART_HEIGHT,
    isRightPosition?: boolean,
): D3SelectFunction {
    let { postfix, maxValue, fraction } = keyFormat || {};
    let maxYValue = postfix === '%' ? 100 : maxValue;

    let { from, to } = getChartRangeValue(points, key, maxYValue);

    let step = (to - from) / 3;
    let ticks: number[] = [];

    for (let i = 0; i < 4; i++) {
        ticks.push(from + step * i);
    }

    let scale = d3ScaleY(height, [from, to]);
    let axis = isRightPosition ? axisLeft : axisRight;
    let chartFraction = maxValue ? fraction : step < 1 ? 1 : 0;

    return axis<number>(scale)
        .tickValues(ticks)
        .tickSize(0)
        .offset(14.5)
        .tickFormat((value) =>
            formatChartValue({
                value,
                ...keyFormat,
                fraction: chartFraction,
            }),
        ) as D3SelectFunction;
}
