import { max } from 'd3-array';

import { ChartKey, ChartPoint } from 'shared/types/ChartPoint';

export function d3Max(points: ChartPoint[], key: ChartKey): Optional<number> {
    return max(points, (point) => {
        let values = point[key];

        return Array.isArray(values) ? Math.max(...values) : values;
    });
}
