import { min } from 'd3-array';

import { ChartKey, ChartPoint } from 'shared/types/ChartPoint';

export function d3Min(points: ChartPoint[], key: ChartKey): Optional<number> {
    return min(points, (point) => {
        let values = point[key];

        return Array.isArray(values) ? Math.min(...values) : values;
    });
}
