import { extent } from 'd3-array';
import { ScaleTime, scaleTime } from 'd3-scale';

import { ChartPoint } from 'shared/types/ChartPoint';

export function d3ScaleTime(
    points: ChartPoint[],
    width: number,
    marginLeft: number = 0,
    marginRight: number = 0,
): ScaleTime<number, number> {
    return scaleTime()
        .domain(extent(points, (point) => point.begin_date) as number[])
        .range([marginLeft, width - marginRight]);
}
