import { max, min } from 'd3-array';
import { ScaleLinear, scaleLinear } from 'd3-scale';

import { ChartPoint } from 'shared/types/ChartPoint';

export function d3ScaleTimeLinear(
    points: ChartPoint[],
    width: number,
    marginLeft: number = 0,
    marginRight: number = 0,
): ScaleLinear<number, number> {
    const bottomAxisValues = points.map((point) => point.begin_date);
    const maxPoint = max(bottomAxisValues) || 1;
    const minPoint = min(bottomAxisValues) || 0;

    return scaleLinear()
        .domain([minPoint, maxPoint])
        .range([marginLeft, width - marginRight]);
}
