import { ScaleLinear, scaleLinear } from 'd3-scale';

import { CHART_AXIS_MARGIN_BOTTOM, CHART_MARGIN_BOTTOM, CHART_MARGIN_TOP } from 'shared/consts/Chart';

const MAX_RANGE = 3;
const DEFAULE_RANGE = [0, MAX_RANGE];

export function d3ScaleY(height: number, range = DEFAULE_RANGE, hasAxis: boolean = true): ScaleLinear<number, number> {
    return scaleLinear()
        .domain(range)
        .range([height - (hasAxis ? CHART_AXIS_MARGIN_BOTTOM : CHART_MARGIN_BOTTOM), CHART_MARGIN_TOP]);
}
