import { axisRight } from 'd3-axis';
import { scaleLinear } from 'd3-scale';
import { select as d3Select } from 'd3-selection';

import { CHART_MARGIN_BOTTOM, CHART_MARGIN_TOP } from 'shared/consts/Chart';
import { D3SelectFunction } from 'shared/types/D3SelectFunction';

const MAX_RANGE = 10;
const DEFAULE_RANGE = [0, MAX_RANGE];

export function d3SelectDottedLines(
    offset: number,
    color: string,
    width: number,
    height: number,
    element: Nullable<SVGGElement>,
): void {
    let scale = scaleLinear()
        .domain(DEFAULE_RANGE)
        .range([height - CHART_MARGIN_BOTTOM, CHART_MARGIN_TOP]);

    let yAxis = axisRight(scale)
        .offset(scale(offset))
        .ticks(1)
        .tickSize(width)
        .tickFormat(() => '');

    d3Select(element)
        .call(yAxis as D3SelectFunction)
        .call((g) => {
            g.selectAll('.tick line').attr('stroke-dasharray', '3 3').attr('stroke', color);
        });
}
