import { axisRight } from 'd3-axis';
import { ScaleLinear } from 'd3-scale';
import { select as d3Select } from 'd3-selection';

import { D3SelectFunction } from 'shared/types/D3SelectFunction';

export function d3SelectLines(
    yScale: ScaleLinear<number, number>,
    width: number,
    element: Nullable<SVGGElement>,
): void {
    let yAxis = axisRight(yScale)
        // eslint-disable-next-line @typescript-eslint/no-magic-numbers
        .ticks(4)
        .tickSize(width)
        .tickFormat(() => '');

    d3Select(element)
        .call(yAxis as D3SelectFunction)
        .call((g) => g.selectAll('.tick line').attr('stroke-opacity', 1));
}
