import { axisBottom } from 'd3-axis';
import { ScaleLinear } from 'd3-scale';
import { select as d3Select } from 'd3-selection';

import { CHART_AXIS_MARGIN_BOTTOM, CHART_MARGIN_TOP } from 'shared/consts/Chart';
import { ChartPoint } from 'shared/types/ChartPoint';
import { D3SelectFunction } from 'shared/types/D3SelectFunction';

export function d3SelectNumbers(
    points: ChartPoint[],
    scaleTime: ScaleLinear<number, number>,
    height: number,
    element: Nullable<SVGGElement>,
): void {
    let xAxis = axisBottom<number>(scaleTime).tickSize(height - CHART_MARGIN_TOP - CHART_AXIS_MARGIN_BOTTOM);

    d3Select(element)
        .call(xAxis as D3SelectFunction)
        .call((g) => g.selectAll('.tick line').remove());
}
