import { select as d3Select } from 'd3-selection';

import { d3AxisSignature } from 'shared/helpers/d3AxisSignature/d3AxisSignature';
import { ChartKeysFormat } from 'shared/types/ChartKeysFormat';
import { ChartKey, ChartPoint } from 'shared/types/ChartPoint';

export interface D3SelectSignaturesProps {
    points: ChartPoint[];
    keys: ChartKey[];
    keysFormat?: ChartKeysFormat[];
    height: number;
    leftAxisElement: Nullable<SVGGElement>;
    rightAxisElement: Nullable<SVGGElement>;
}

export function d3SelectSignatures({
    points,
    keys,
    keysFormat = [],
    height,
    leftAxisElement,
    rightAxisElement,
}: D3SelectSignaturesProps): void {
    let keysLength = keys.length;

    if (keysLength) {
        d3Select(leftAxisElement).call(d3AxisSignature(points, keys[0], keysFormat[0], height));

        if (keysLength >= 2) {
            d3Select(rightAxisElement).call(d3AxisSignature(points, keys[1], keysFormat[1], height, true));
        }
    }
}
