export function debounce<T extends (...args: any[]) => void>(
    fn: T,
    interval: number,
): (...args: Parameters<T>) => void {
    let lastArgs: Optional<any[]> = undefined;
    let timerId: Optional<number> = undefined;

    function flush() {
        if (lastArgs) {
            fn(...lastArgs);
            cancel();
        }
    }

    function cancel() {
        lastArgs = undefined;

        if (timerId) {
            clearTimeout(timerId);
            timerId = undefined;
        }
    }

    return function debouncedFn(...args: Parameters<T>): void {
        cancel();

        lastArgs = args;
        setTimeout(flush, interval);
    };
}
