import { EMPTY_DATA } from 'constants/constants';

import { formatNumber } from 'shared/helpers/formatNumber/formatNumber';

export function formatBookings(value?: number, fraction: number = 0): string {
    if (value === undefined) {
        return EMPTY_DATA;
    }

    return formatNumber(value, {
        minimumFractionDigits: fraction,
        maximumFractionDigits: fraction,
    });
}
