import { formatNumber } from 'shared/helpers/formatNumber/formatNumber';
import { getMinFraction } from 'shared/helpers/getMinFraction/getMinFraction';

export interface FormatChartValueProps {
    value: Nullable<number>;
    prefix?: string;
    postfix?: string;
    fraction?: number;
}

export function formatChartValue({ value, prefix = '', postfix = '', fraction }: FormatChartValueProps): string {
    fraction = getMinFraction(value, fraction);

    let numStr = formatNumber(value, {
        minimumFractionDigits: fraction,
        maximumFractionDigits: fraction,
    });

    return `${prefix} ${numStr} ${postfix}`.trim();
}
