import { EMPTY_DATA } from 'constants/constants';

import { formatNumber } from 'shared/helpers/formatNumber/formatNumber';

export function formatCurrency(value?: number, currency?: string): string {
    if (value === undefined) {
        return EMPTY_DATA;
    }

    const formattedValue = formatNumber(value, {
        minimumFractionDigits: 0,
        maximumFractionDigits: 0,
    });

    return `${formattedValue} ${currency}`;
}
