import { getI18nLocale } from 'utils/language/getI18nLocale';

import { formatTime } from 'shared/helpers/formatTime/formatTime';
import { getDateString } from 'shared/helpers/getDateString/getDateString';

const DATE_FORMAT: Intl.DateTimeFormatOptions = {
    day: 'numeric',
    month: 'short',
    year: 'numeric',
};

export interface FormatDateTimeStringOptions {
    date: Date;
    time?: string;
    format?: Intl.DateTimeFormatOptions;
}

// @todo: add unit test
export function formatDateTimeString({ date, time, format = DATE_FORMAT }: FormatDateTimeStringOptions): string {
    const locale = getI18nLocale();

    return `${getDateString(date, locale, format)} ${time || formatTime(date)}`;
}
