export function formatDateToString(date: Nullish<Date | number>, withoutYear?: boolean): Optional<string> {
    if (!date) {
        return;
    }

    const d = new Date(date);
    const year = d.getFullYear();
    let month = '' + (d.getMonth() + 1);
    let day = '' + d.getDate();

    if (month.length < 2) {
        month = '0' + month;
    }

    if (day.length < 2) {
        day = '0' + day;
    }

    if (withoutYear) {
        return [day, month].join('.');
    }

    return [year, month, day].join('-');
}
