import { i18n as i18nBuilder, keyset, MovaLang, plurals } from 'mova-i18n';

const translates = keyset({
    '{count} day': {
        _meta: {
            status: {
                en: 'REQUIRES_TRANSLATION',
                ru: 'REQUIRES_TRANSLATION',
                cs: 'APPROVED',
            },
        },
        en: {
            one: '{count} day',
            other: '{count} days',
        },
        ru: {
            one: '{count} день',
            few: '{count} дня',
            many: '{count} дней',
        },
        cs: {
            one: '{count} den',
            few: '{count} dny',
            other: '{count} dní',
        },
    },
});

export const i18n = i18nBuilder(process.env.LANG as MovaLang, plurals)(translates);
