import { i18n } from 'shared/helpers/formatDay/formatDay.i18n';

export function formatDay(day: number | { value: string; count: number }): string {
    if (typeof day === 'number') {
        return i18n('{count} day', {
            count: day,
        });
    }

    return i18n('{count} day', {
        count: day.value,
        _count: day.count,
    });
}
