import { i18n as i18nBuilder, keyset, MovaLang, plurals } from 'mova-i18n';

const translates = keyset({
    '{value} h': {
        _meta: {
            status: {
                en: 'REQUIRES_TRANSLATION',
                ru: 'REQUIRES_TRANSLATION',
                cs: 'APPROVED',
            },
        },
        en: '{value} h',
        ru: '{value} ч',
        cs: '{value} h',
    },
});

export const i18n = i18nBuilder(process.env.LANG as MovaLang, plurals)(translates);
