import { EMPTY_DATA } from 'constants/constants';

import { formatNumber } from 'shared/helpers/formatNumber/formatNumber';

import { i18n } from 'shared/helpers/formatHours/formatHours.i18n';

export function formatHours(value?: number): string {
    if (value === undefined) {
        return EMPTY_DATA;
    }

    return i18n('{value} h', {
        value: formatNumber(value, {
            minimumFractionDigits: 0,
            maximumFractionDigits: 0,
        }),
    });
}
