import { EMPTY_DATA } from 'constants/constants';

import { formatNumber } from 'shared/helpers/formatNumber/formatNumber';

import { i18n } from 'shared/helpers/formatMileage/formatMileage.i18n';

export function formatMileage(value?: number): string {
    if (value === undefined) {
        return EMPTY_DATA;
    }

    return i18n('{value} km', {
        value: formatNumber(value, {
            minimumFractionDigits: 0,
            maximumFractionDigits: 0,
        }),
    });
}
