import { i18n as i18nBuilder, keyset, MovaLang, plurals } from 'mova-i18n';

const translates = keyset({
    '{count} hour': {
        _meta: {
            status: {
                en: 'REQUIRES_TRANSLATION',
                ru: 'REQUIRES_TRANSLATION',
                cs: 'REQUIRES_TRANSLATION',
            },
        },
        en: {
            one: '{count} hour',
            other: '{count} hours',
        },
        ru: {
            one: '{count} час',
            few: '{count} часа',
            many: '{count} часов',
        },
        cs: {
            one: '',
            few: '',
            other: '',
        },
    },
    '{count} minute': {
        _meta: {
            status: {
                en: 'REQUIRES_TRANSLATION',
                ru: 'REQUIRES_TRANSLATION',
                cs: 'REQUIRES_TRANSLATION',
            },
        },
        en: {
            one: '{count} minute',
            other: '{count} minutes',
        },
        ru: {
            one: '{count} минута',
            few: '{count} минуты',
            many: '{count} минут',
        },
        cs: {
            one: '',
            few: '',
            other: '',
        },
    },
});

export const i18n = i18nBuilder(process.env.LANG as MovaLang, plurals)(translates);
