import { HOURS_IN_DAY, MINUTES_IN_HOUR, ONE_DAY, ONE_HOUR, ONE_MINUTE } from 'constants/constants';

import { formatDay } from 'shared/helpers/formatDay/formatDay';

import { i18n } from 'shared/helpers/formatMillisecondsToString/formatMillisecondsToString.i18n';

export function formatMillisecondsToString(ms: number) {
    let days = Math.floor(ms / ONE_DAY);
    let hours = Math.floor((ms - days * ONE_DAY) / ONE_HOUR);
    let minutes = Math.round((ms - days * ONE_DAY - hours * ONE_HOUR) / ONE_MINUTE);

    if (minutes === MINUTES_IN_HOUR) {
        hours++;
        minutes = 0;
    }

    if (hours === HOURS_IN_DAY) {
        days++;
        hours = 0;
    }

    const minutesWithText = i18n('{count} minute', { count: minutes });
    const hoursWithText = i18n('{count} hour', { count: hours });
    const daysWithText = formatDay(days);

    if (days >= 1) {
        return hours > 1 ? `${daysWithText} ${hoursWithText}` : daysWithText;
    }

    if (hours >= 1) {
        return minutes > 1 ? `${hoursWithText} ${minutesWithText}` : hoursWithText;
    }

    return minutesWithText;
}
