import { PHONE_MASKS } from 'shared/consts/phone';

export function formatPhoneNumber(value: Optional<string>): Optional<string> {
    let formatted;

    PHONE_MASKS.some(({ mask }) => {
        let match = value?.match(mask);

        if (match && !formatted) {
            match.shift();

            formatted = match.join(' ');
        }
    });

    return formatted;
}
